#!/usr/bin/env bash

# Parameters
env_names=("Hopper-v2" "Walker2d-v2" "Ant-v2" "HalfCheetah-v2" "Humanoid-v2" "Reacher-v2" "Swimmer-v2" "InvertedPendulum-v2" "InvertedDoublePendulum-v2")
seeds_sac=(0 1 0 1 3 0 3 0 2)
seeds_gru=(0 3 4 3 1 4 4 0 4)
steps=(8 4 4 4 8 8 4 4 4)
train_steps=(8 4 4 4 16 8 8 4 2)
count=0

# Log file for job submissions
log_file="job_submission_log.txt"
> $log_file  # Clear the log file at the start

# Loop over the indices of the arrays
for i in "${!env_names[@]}"; do
    env_name=${env_names[$i]}
    seed_gru=${seeds_gru[$i]}
    seed_sac=${seeds_sac[$i]}
    step=${steps[$i]}
    train_step=${train_steps[$i]}

    # Submit the job and pass env_name, seed, and step
    sbatch --job-name="eval_${env_name}" record_videos.sh $seed_gru $seed_sac $env_name $step $train_step
    echo "Submitted job for env=$env_name, seed=$seed, steps=$step" | tee -a $log_file
    count=$((count + 1))
done

echo "Launched $count jobs."

